/* RSA-Angriff C#.cs : 
 * Benchmarkversion testet Laufzeitverhalten primitiver Datentypen.
 *  - Konsolenprogramm
 *  - Auswahl zwischen bitorientierter Routine mit aufwndiger Rekursion DoPrim2() 
 *    und BruteForce-Routine DoPrimBruteForce() schlicht durch Auskommentieren in main()
 *  - zu zerlegende Zahl als BigNumber definiert. 
 *
 *  Anmerkung: DoPrimBruteForce() findet auch kleine Primfaktoren, 
 *             DoPrim2() ignoriert diese, da RSA-Paare immer groe Primfaktoren haben 
 *             (thats a bug, but also a feature)
*/
using System;
namespace RSA_Angriff
{
	class RSA_Angriff
	{

    const long BigNumber = 34571237124234713;         
    
    static long UBound; 
    static long z;   // enthlt die zu zerlegende Zahl


    [STAThread]
		static void Main(string[] args)
		{
			System.DateTime start = System.DateTime.Now; 
      Console.WriteLine("C#: Zerlege {0}", BigNumber);
			if ((args.Length == 0) || (args[0].ToUpper() != "-R"))
			{
				Console.WriteLine("Brute Force (Aufruf mit -R = rekursives Verfahren)");
				DoPrimBruteForce(BigNumber);
			}
			else
			{
				Console.WriteLine("Rekursiver Ansatz (Aufruf ohne -R = Brute Force)");
				DoPrim2(BigNumber);
			}
			System.DateTime end = System.DateTime.Now; 
      Console.WriteLine("Dauer:     {0}", end-start);
			Console.Write("Enter drcken");
			Console.Read();
		}

    public static void DoPrimBruteForce(long NumberToCrunch)
    {
      long i; 
      for (i = 3; i < System.Math.Sqrt(NumberToCrunch); i+=2)
      {
        if(NumberToCrunch % i == 0)
        {
          long j = NumberToCrunch / i;
          Console.WriteLine("{0} * {1} = {2}", i, j, NumberToCrunch);
        };
      }
    }
    

		static void DoPrim2(long NumberToCrunch)
		{
      z = NumberToCrunch;
      UBound = (long) Math.Sqrt(z);    // Wurzelkriterium
      Prim(3, 2, 1, 1, 1);              // Start der Rekursion
		}

		static void Prim(
      int n,   // Bitmaske bis m-te Stelle, also 2^m - 1
      int m,   // Stelle (Zweierpotenz)
      long i,  // 1. Kandidat fr Primzahl
      long j,  // 2. Kandidat fr Primzahl
      long res // Bisher auf m Stellen synthetisiertes Produkt
      )
		{   
      long product;
					product = i * j;   // berlauf? dann Ende der Rekursion
      
      // Rekursion bricht ab, wenn 
      //   - 1. Kandidat grer als Wurzel der Zahl
      //   - Produkt zu gro
      //   - m wegen berlauf negativ wird
      if ( i < UBound && product < z && m > 0)
			{
				long z0 = z & n;   // Ausfiltern der relevanten Stellen
				int m1 = m<<1;     // nchste Stelle
				int n1 = n|m1;     // Bitmaske erweitern

        // Tiefensuche rekursiv!
        // Es gibt vier mgliche Flle, je zwei pro Kandidat
        // zwei davon gehen in die Rekursion
        // relevant sind nur m Stellen

				if ((res & n) == z0)        // +0, +0 (i, j unverndert)
					Prim(n1, m1, i, j, res);

				long im = i|m;     // m-tes Bit der Kandidaten setzen
				long jm = j|m; 
        // Testen ob die letzten m Stellen des Kandidatenprodukts stimmen
				if (((res = im * j) & n) == z0)     // +1, +0 (m-tes Bit von i gesetzt)
					Prim(n1, m1, im, j, res);    
				if ( ((res = i * jm) & n) == z0)    // +0, +1 (m-tes Bit von j gesetzt)
					Prim(n1, m1, i, jm, res);
				if ( ( (res = im * jm) & n) == z0)  // +1, +1 (m-tes Bit von i,j gesetzt)
					Prim(n1, m1, im, jm, res);  
			}
			else  // Rekursion bricht ab. Stimmt das Produkt etwa?
				if (i < UBound && product == z)  
				{
					Console.WriteLine("{0} * {1} = {2}", (long) i , (long)j ,z);
					return; 
				}
		}
	}
}
